/*
 * Decompiled with CFR 0.152.
 */
package Verifier;

import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class CL_EmailValidator {
    private static final String EMAIL_REGEX = "^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[A-Z0-9._%+-]+@[A-Z0-9.-]+\\.[A-Z]{2,}$", 2);

    public static void main(String[] args) {
        String[] tests;
        String[] stringArray = tests = new String[]{"test@example.com", "john.doe+tag@sub.domain.co.uk", "invalid@@example.com", "no-at-symbol.com", "bad-char!@example.com", "a@b", "user@localhost"};
        int n = tests.length;
        int n2 = 0;
        while (n2 < n) {
            String email = stringArray[n2];
            System.out.println("=== " + email + " ===");
            System.out.println("Syntaxe basique OK ? " + CL_EmailValidator.checkBasicSyntax(email));
            System.out.println("Regex OK ? " + CL_EmailValidator.checkRegex(email));
            System.out.println("MX DNS OK ? " + CL_EmailValidator.checkMxRecord(email));
            System.out.println();
            ++n2;
        }
    }

    public static boolean checkBasicSyntax(String email) {
        if (email == null) {
            return false;
        }
        if (email.length() < 6 || email.length() > 254) {
            return false;
        }
        int atIndex = email.indexOf(64);
        int lastAtIndex = email.lastIndexOf(64);
        if (atIndex <= 0 || atIndex != lastAtIndex) {
            return false;
        }
        String localPart = email.substring(0, atIndex);
        String domainPart = email.substring(atIndex + 1);
        if (localPart.isEmpty() || domainPart.isEmpty()) {
            return false;
        }
        if (email.contains(" ")) {
            return false;
        }
        if (!domainPart.contains(".")) {
            return false;
        }
        if (domainPart.startsWith(".") || domainPart.endsWith(".")) {
            return false;
        }
        return !domainPart.contains("..");
    }

    public static boolean checkRegex(String email) {
        if (email == null) {
            return false;
        }
        Matcher matcher = EMAIL_PATTERN.matcher(email);
        return matcher.matches();
    }

    public static boolean checkMxRecord(String email) {
        if (email == null) {
            return false;
        }
        int atIndex = email.lastIndexOf(64);
        if (atIndex < 0 || atIndex == email.length() - 1) {
            return false;
        }
        String domain = email.substring(atIndex + 1);
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            InitialDirContext ctx = new InitialDirContext(env);
            Attributes attrs = ctx.getAttributes(domain, new String[]{"MX"});
            Attribute attr = attrs.get("MX");
            if (attr == null || attr.size() == 0) {
                attrs = ctx.getAttributes(domain, new String[]{"A"});
                attr = attrs.get("A");
            }
            return attr != null && attr.size() > 0;
        }
        catch (Exception e) {
            return false;
        }
    }
}

