/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.FileScanner;
import com.izforge.izpack.util.file.FileUtils;
import com.izforge.izpack.util.file.types.Resource;
import com.izforge.izpack.util.file.types.ResourceFactory;
import com.izforge.izpack.util.file.types.selectors.FileSelector;
import com.izforge.izpack.util.file.types.selectors.SelectorUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class DirectoryScanner
implements FileScanner,
ResourceFactory {
    private InstallData idata;
    protected static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/.svn", "**/.svn/**", "**/.DS_Store"};
    private static final boolean[] CS_SCAN_ONLY = new boolean[]{true};
    private static final boolean[] CS_THEN_NON_CS = new boolean[]{true, false};
    private static Vector<String> defaultExcludes = new Vector();
    private File basedir;
    private String[] includes;
    private String[] excludes;
    private final FileSelector[] selectors = null;
    private Vector<String> filesIncluded;
    private Vector<String> filesNotIncluded;
    private Vector<String> filesExcluded;
    private Vector<String> dirsIncluded;
    private Vector<String> dirsNotIncluded;
    private Vector<String> dirsExcluded;
    private Vector<String> filesDeselected;
    private Vector<String> dirsDeselected;
    private boolean haveSlowResults = false;
    private boolean isCaseSensitive = true;
    private boolean followSymlinks = true;
    private boolean everythingIncluded = true;
    private final Map<File, String[]> fileListMap = new HashMap<File, String[]>();
    private final Set<String> scannedDirs = new HashSet<String>();
    private final Set<String> includeNonPatterns = new HashSet<String>();
    private final Set<String> excludeNonPatterns = new HashSet<String>();
    private String[] includePatterns;
    private String[] excludePatterns;
    private boolean areNonPatternSetsReady = false;
    private boolean scanning = false;
    private final Object scanLock = new Object();
    private boolean slowScanning = false;
    private final Object slowScanLock = new Object();
    private Exception illegal = null;

    protected static boolean matchPatternStart(String pattern, String str) {
        return SelectorUtils.matchPatternStart(pattern, str);
    }

    private static boolean matchPatternStart(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str) {
        return SelectorUtils.matchPath(pattern, str);
    }

    private static boolean matchPath(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str, isCaseSensitive);
    }

    public static boolean match(String pattern, String str) {
        return SelectorUtils.match(pattern, str);
    }

    protected static boolean match(String pattern, String str, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str, isCaseSensitive);
    }

    private static String[] getDefaultExcludes() {
        return defaultExcludes.toArray(new String[defaultExcludes.size()]);
    }

    public static boolean addDefaultExclude(String s) {
        if (defaultExcludes.indexOf(s) == -1) {
            defaultExcludes.add(s);
            return true;
        }
        return false;
    }

    public static boolean removeDefaultExclude(String s) {
        return defaultExcludes.remove(s);
    }

    private static void resetDefaultExcludes() {
        defaultExcludes = new Vector();
        defaultExcludes.addAll(Arrays.asList(DEFAULTEXCLUDES));
    }

    @Override
    public void setBasedir(String basedir) {
        this.setBasedir(new File(basedir.replace('/', File.separatorChar).replace('\\', File.separatorChar)));
    }

    @Override
    public synchronized void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    @Override
    public synchronized File getBasedir() {
        return this.basedir;
    }

    private synchronized boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public synchronized void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public synchronized boolean isFollowSymlinks() {
        return this.followSymlinks;
    }

    public synchronized void setFollowSymlinks(boolean followSymlinks) {
        this.followSymlinks = followSymlinks;
    }

    @Override
    public synchronized void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                this.includes[i] = DirectoryScanner.normalizePattern(includes[i]);
            }
        }
    }

    @Override
    public synchronized void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                this.excludes[i] = DirectoryScanner.normalizePattern(excludes[i]);
            }
        }
    }

    public synchronized void addExcludes(String[] excludes) {
        if (excludes != null && excludes.length > 0) {
            if (this.excludes != null && this.excludes.length > 0) {
                String[] tmp = new String[excludes.length + this.excludes.length];
                System.arraycopy(this.excludes, 0, tmp, 0, this.excludes.length);
                for (int i = 0; i < excludes.length; ++i) {
                    tmp[this.excludes.length + i] = DirectoryScanner.normalizePattern(excludes[i]);
                }
                this.excludes = tmp;
            } else {
                this.setExcludes(excludes);
            }
        }
    }

    private static String normalizePattern(String p) {
        String pattern = p.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        if (pattern.endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    public synchronized boolean isEverythingIncluded() {
        return this.everythingIncluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scan() throws Exception {
        Object object = this.scanLock;
        synchronized (object) {
            if (this.scanning) {
                while (this.scanning) {
                    try {
                        this.scanLock.wait();
                    }
                    catch (InterruptedException ignored) {}
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                return;
            }
            this.scanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                String[] stringArray;
                boolean nullIncludes;
                this.illegal = null;
                this.clearResults();
                boolean bl = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean nullExcludes = this.excludes == null;
                String[] stringArray3 = this.excludes = nullExcludes ? new String[]{} : this.excludes;
                if (this.basedir == null) {
                    this.illegal = new Exception("No basedir set");
                } else {
                    if (!this.basedir.exists()) {
                        this.illegal = new Exception("basedir " + this.basedir + " does not exist");
                    }
                    if (!this.basedir.isDirectory()) {
                        this.illegal = new Exception("basedir " + this.basedir + " is not a directory");
                    }
                }
                if (this.illegal != null) {
                    throw this.illegal;
                }
                if (this.isIncluded("")) {
                    if (!this.isExcluded("")) {
                        if (this.isSelected("", this.basedir)) {
                            this.dirsIncluded.addElement("");
                        } else {
                            this.dirsDeselected.addElement("");
                        }
                    } else {
                        this.dirsExcluded.addElement("");
                    }
                } else {
                    this.dirsNotIncluded.addElement("");
                }
                this.checkIncludePatterns();
                this.clearCaches();
                this.includes = nullIncludes ? null : this.includes;
                this.excludes = nullExcludes ? null : this.excludes;
            }
        }
        finally {
            object = this.scanLock;
            synchronized (object) {
                this.scanning = false;
                this.scanLock.notifyAll();
            }
        }
    }

    private void checkIncludePatterns() throws Exception {
        Hashtable<String, String> newroots = new Hashtable<String, String>();
        for (String include : this.includes) {
            newroots.put(SelectorUtils.rtrimWildcardTokens(include), include);
        }
        if (newroots.containsKey("")) {
            this.scandir(this.basedir, "", true);
        } else {
            File canonBase;
            Enumeration enum2 = newroots.keys();
            try {
                canonBase = this.basedir.getCanonicalFile();
            }
            catch (IOException ex) {
                throw new Exception(ex);
            }
            while (enum2.hasMoreElements()) {
                File f;
                String currentelement = (String)enum2.nextElement();
                String originalpattern = (String)newroots.get(currentelement);
                File myfile = new File(this.basedir, currentelement);
                if (myfile.exists()) {
                    try {
                        File canonFile = myfile.getCanonicalFile();
                        String path = FileUtils.removeLeadingPath(canonBase, canonFile);
                        if (!path.equals(currentelement) && (myfile = this.findFile(this.basedir, currentelement, true)) != null) {
                            currentelement = FileUtils.removeLeadingPath(this.basedir, myfile);
                        }
                    }
                    catch (IOException ex) {
                        throw new Exception(ex);
                    }
                }
                if (!(myfile != null && myfile.exists() || this.isCaseSensitive() || (f = this.findFile(this.basedir, currentelement, false)) == null || !f.exists())) {
                    currentelement = FileUtils.removeLeadingPath(this.basedir, f);
                    myfile = f;
                }
                if (myfile == null || !myfile.exists() || !this.followSymlinks && this.isSymlink(this.basedir, currentelement)) continue;
                if (myfile.isDirectory()) {
                    if (this.isIncluded(currentelement) && currentelement.length() > 0) {
                        this.accountForIncludedDir(currentelement, myfile, true);
                        continue;
                    }
                    if (currentelement.length() > 0 && currentelement.charAt(currentelement.length() - 1) != File.separatorChar) {
                        currentelement = currentelement + File.separatorChar;
                    }
                    this.scandir(myfile, currentelement, true);
                    continue;
                }
                boolean included = this.isCaseSensitive() ? originalpattern.equals(currentelement) : originalpattern.equalsIgnoreCase(currentelement);
                if (!included) continue;
                this.accountForIncludedFile(currentelement, myfile);
            }
        }
    }

    private synchronized void clearResults() {
        this.filesIncluded = new Vector();
        this.filesNotIncluded = new Vector();
        this.filesExcluded = new Vector();
        this.filesDeselected = new Vector();
        this.dirsIncluded = new Vector();
        this.dirsNotIncluded = new Vector();
        this.dirsExcluded = new Vector();
        this.dirsDeselected = new Vector();
        this.everythingIncluded = this.basedir != null;
        this.scannedDirs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void slowScan() throws Exception {
        Object object = this.slowScanLock;
        synchronized (object) {
            if (this.haveSlowResults) {
                return;
            }
            if (this.slowScanning) {
                while (this.slowScanning) {
                    try {
                        this.slowScanLock.wait();
                    }
                    catch (InterruptedException ignored) {}
                }
                return;
            }
            this.slowScanning = true;
        }
        try {
            object = this;
            synchronized (object) {
                String[] stringArray;
                boolean nullIncludes;
                boolean bl = nullIncludes = this.includes == null;
                if (nullIncludes) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "**";
                } else {
                    stringArray = this.includes;
                }
                this.includes = stringArray;
                boolean nullExcludes = this.excludes == null;
                this.excludes = nullExcludes ? new String[]{} : this.excludes;
                Object[] excl = new String[this.dirsExcluded.size()];
                this.dirsExcluded.copyInto(excl);
                Object[] notIncl = new String[this.dirsNotIncluded.size()];
                this.dirsNotIncluded.copyInto(notIncl);
                for (Object anExcl : excl) {
                    if (this.couldHoldIncluded((String)anExcl)) continue;
                    this.scandir(new File(this.basedir, (String)anExcl), (String)anExcl + File.separator, false);
                }
                for (Object aNotIncl : notIncl) {
                    if (this.couldHoldIncluded((String)aNotIncl)) continue;
                    this.scandir(new File(this.basedir, (String)aNotIncl), (String)aNotIncl + File.separator, false);
                }
                this.clearCaches();
                this.includes = nullIncludes ? null : this.includes;
                this.excludes = nullExcludes ? null : this.excludes;
            }
        }
        finally {
            object = this.slowScanLock;
            synchronized (object) {
                this.haveSlowResults = true;
                this.slowScanning = false;
                this.slowScanLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scandir(File dir, String vpath, boolean fast) throws Exception {
        if (dir == null) {
            throw new Exception("dir must not be null.");
        }
        if (!dir.exists()) {
            throw new Exception(dir + " doesn't exists.");
        }
        if (!dir.isDirectory()) {
            throw new Exception(dir + " is not a directory.");
        }
        if (fast && this.hasBeenScanned(vpath)) {
            return;
        }
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            throw new Exception("IO error scanning directory " + dir.getAbsolutePath());
        }
        if (!this.followSymlinks) {
            void var8_10;
            Vector<String> noLinks = new Vector<String>();
            Object[] arr$ = newfiles;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_10 < len$) {
                String string = arr$[var8_10];
                try {
                    if (FileUtils.isSymbolicLink(dir, string)) {
                        String name = vpath + string;
                        File file = new File(dir, string);
                        (file.isDirectory() ? this.dirsExcluded : this.filesExcluded).addElement(name);
                    } else {
                        noLinks.addElement(string);
                    }
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    System.err.println(msg);
                    noLinks.addElement(string);
                }
                ++var8_10;
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        for (String string : newfiles) {
            String string2 = vpath + string;
            File file = new File(dir, string);
            if (file.isDirectory()) {
                if (this.isIncluded(string2)) {
                    this.accountForIncludedDir(string2, file, fast);
                } else {
                    this.everythingIncluded = false;
                    this.dirsNotIncluded.addElement(string2);
                    if (fast && this.couldHoldIncluded(string2)) {
                        this.scandir(file, string2 + File.separator, fast);
                    }
                }
                if (fast) continue;
                this.scandir(file, string2 + File.separator, fast);
                continue;
            }
            if (!file.isFile()) continue;
            if (this.isIncluded(string2)) {
                this.accountForIncludedFile(string2, file);
                continue;
            }
            this.everythingIncluded = false;
            this.filesNotIncluded.addElement(string2);
        }
    }

    private void accountForIncludedFile(String name, File file) throws Exception {
        if (this.filesIncluded.contains(name) || this.filesExcluded.contains(name) || this.filesDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.filesExcluded.addElement(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.filesIncluded.addElement(name);
        } else {
            this.filesDeselected.addElement(name);
        }
        this.everythingIncluded &= included;
    }

    private void accountForIncludedDir(String name, File file, boolean fast) throws Exception {
        if (this.dirsIncluded.contains(name) || this.dirsExcluded.contains(name) || this.dirsDeselected.contains(name)) {
            return;
        }
        boolean included = false;
        if (this.isExcluded(name)) {
            this.dirsExcluded.addElement(name);
        } else if (this.isSelected(name, file)) {
            included = true;
            this.dirsIncluded.addElement(name);
        } else {
            this.dirsDeselected.addElement(name);
        }
        this.everythingIncluded &= included;
        if (fast && this.couldHoldIncluded(name) && !this.contentsExcluded(name)) {
            this.scandir(file, name + File.separator, fast);
        }
    }

    private boolean isIncluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.includeNonPatterns.contains(name) : this.includeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (String includePattern : this.includePatterns) {
            if (!DirectoryScanner.matchPath(includePattern, name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    private boolean couldHoldIncluded(String name) {
        for (String include : this.includes) {
            if (!DirectoryScanner.matchPatternStart(include, name, this.isCaseSensitive()) || !this.isMorePowerfulThanExcludes(name, include) || !this.isDeeper(include, name)) continue;
            return true;
        }
        return false;
    }

    private boolean isDeeper(String pattern, String name) {
        Vector<String> p = SelectorUtils.tokenizePath(pattern);
        Vector<String> n = SelectorUtils.tokenizePath(name);
        return p.contains("**") || p.size() > n.size();
    }

    private boolean isMorePowerfulThanExcludes(String name, String includepattern) {
        String soughtexclude = name + File.separator + "**";
        for (String exclude : this.excludes) {
            if (!exclude.equals(soughtexclude)) continue;
            return false;
        }
        return true;
    }

    private boolean contentsExcluded(String name) {
        name = name.endsWith(File.separator) ? name : name + File.separator;
        for (String e : this.excludes) {
            if (!e.endsWith("**") || !SelectorUtils.matchPath(e.substring(0, e.length() - 2), name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(String name) {
        this.ensureNonPatternSetsReady();
        if (this.isCaseSensitive() ? this.excludeNonPatterns.contains(name) : this.excludeNonPatterns.contains(name.toUpperCase())) {
            return true;
        }
        for (String excludePattern : this.excludePatterns) {
            if (!DirectoryScanner.matchPath(excludePattern, name, this.isCaseSensitive())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelected(String name, File file) throws Exception {
        if (this.selectors != null) {
            for (FileSelector selector : this.selectors) {
                if (selector.isSelected(this.idata, this.basedir, name, file)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public synchronized String[] getIncludedFiles() throws Exception {
        if (this.filesIncluded == null) {
            throw new Exception();
        }
        Object[] files = new String[this.filesIncluded.size()];
        this.filesIncluded.copyInto(files);
        Arrays.sort(files);
        return files;
    }

    public synchronized int getIncludedFilesCount() throws Exception {
        if (this.filesIncluded == null) {
            throw new Exception();
        }
        return this.filesIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedFiles() throws Exception {
        this.slowScan();
        Object[] files = new String[this.filesNotIncluded.size()];
        this.filesNotIncluded.copyInto(files);
        return files;
    }

    @Override
    public synchronized String[] getExcludedFiles() throws Exception {
        this.slowScan();
        Object[] files = new String[this.filesExcluded.size()];
        this.filesExcluded.copyInto(files);
        return files;
    }

    public synchronized String[] getDeselectedFiles() throws Exception {
        this.slowScan();
        Object[] files = new String[this.filesDeselected.size()];
        this.filesDeselected.copyInto(files);
        return files;
    }

    @Override
    public synchronized String[] getIncludedDirectories() throws Exception {
        if (this.dirsIncluded == null) {
            throw new Exception();
        }
        Object[] directories = new String[this.dirsIncluded.size()];
        this.dirsIncluded.copyInto(directories);
        Arrays.sort(directories);
        return directories;
    }

    public synchronized int getIncludedDirsCount() throws Exception {
        if (this.dirsIncluded == null) {
            throw new Exception();
        }
        return this.dirsIncluded.size();
    }

    @Override
    public synchronized String[] getNotIncludedDirectories() throws Exception {
        this.slowScan();
        Object[] directories = new String[this.dirsNotIncluded.size()];
        this.dirsNotIncluded.copyInto(directories);
        return directories;
    }

    @Override
    public synchronized String[] getExcludedDirectories() throws Exception {
        this.slowScan();
        Object[] directories = new String[this.dirsExcluded.size()];
        this.dirsExcluded.copyInto(directories);
        return directories;
    }

    public synchronized String[] getDeselectedDirectories() throws Exception {
        this.slowScan();
        Object[] directories = new String[this.dirsDeselected.size()];
        this.dirsDeselected.copyInto(directories);
        return directories;
    }

    @Override
    public synchronized void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + defaultExcludes.size()];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        String[] defaultExcludesTemp = DirectoryScanner.getDefaultExcludes();
        for (int i = 0; i < defaultExcludesTemp.length; ++i) {
            newExcludes[i + excludesLength] = defaultExcludesTemp[i].replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    @Override
    public synchronized Resource getResource(String name) throws Exception {
        File f = FileUtils.resolveFile(this.basedir, name);
        return new Resource(name, f.exists(), f.lastModified(), f.isDirectory(), f.length());
    }

    private String[] list(File file) {
        String[] files = this.fileListMap.get(file);
        if (files == null && (files = file.list()) != null) {
            this.fileListMap.put(file, files);
        }
        return files;
    }

    private File findFile(File base, String path, boolean cs) throws Exception {
        return this.findFile(base, SelectorUtils.tokenizePath(path), cs);
    }

    private File findFile(File base, Vector<String> pathElements, boolean cs) throws Exception {
        boolean[] matchCase;
        if (pathElements.size() == 0) {
            return base;
        }
        if (!base.isDirectory()) {
            return null;
        }
        String[] files = this.list(base);
        if (files == null) {
            throw new Exception("IO error scanning directory " + base.getAbsolutePath());
        }
        String current = pathElements.remove(0);
        for (boolean aMatchCase : matchCase = cs ? CS_SCAN_ONLY : CS_THEN_NON_CS) {
            for (String file : files) {
                if (!(aMatchCase ? file.equals(current) : file.equalsIgnoreCase(current))) continue;
                return this.findFile(new File(base, file), pathElements, cs);
            }
        }
        return null;
    }

    private boolean isSymlink(File base, String path) {
        return this.isSymlink(base, SelectorUtils.tokenizePath(path));
    }

    private boolean isSymlink(File base, Vector<String> pathElements) {
        if (pathElements.size() > 0) {
            String current = pathElements.remove(0);
            try {
                return FileUtils.isSymbolicLink(base, current) || this.isSymlink(new File(base, current), pathElements);
            }
            catch (IOException ioe) {
                String msg = "IOException caught while checking for links, couldn't get canonical path!";
                System.err.println(msg);
            }
        }
        return false;
    }

    private boolean hasBeenScanned(String vpath) {
        return !this.scannedDirs.add(vpath);
    }

    Set<String> getScannedDirs() {
        return this.scannedDirs;
    }

    private synchronized void clearCaches() {
        this.fileListMap.clear();
        this.includeNonPatterns.clear();
        this.excludeNonPatterns.clear();
        this.includePatterns = null;
        this.excludePatterns = null;
        this.areNonPatternSetsReady = false;
    }

    private synchronized void ensureNonPatternSetsReady() {
        if (!this.areNonPatternSetsReady) {
            this.includePatterns = this.fillNonPatternSet(this.includeNonPatterns, this.includes);
            this.excludePatterns = this.fillNonPatternSet(this.excludeNonPatterns, this.excludes);
            this.areNonPatternSetsReady = true;
        }
    }

    private String[] fillNonPatternSet(Set<String> set, String[] patterns) {
        ArrayList<String> al = new ArrayList<String>(patterns.length);
        for (String pattern : patterns) {
            if (!SelectorUtils.hasWildcards(pattern)) {
                set.add(this.isCaseSensitive() ? pattern : pattern.toUpperCase());
                continue;
            }
            al.add(pattern);
        }
        return set.size() == 0 ? patterns : al.toArray(new String[al.size()]);
    }

    static {
        DirectoryScanner.resetDefaultExcludes();
    }
}

